<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->hasOne('App\Models\CustomerType', 'customer_type_id');
    }

    public function remarks()
    {
        return $this->hasMany('App\Models\CustomerRemark');
    }

    public function contacts()
    {
        return $this->hasManyThrough('App\Models\Contact', 'App\Models\CustomerContact');
    }

    public function tags()
    {
        return $this->hasManyThrough('App\Models\Tag', 'App\Models\CustomerTag');
    }

}